<?php

/*=================================================================================
 * #WooCommerce helper functions
 *=================================================================================*/

if(!function_exists('hudson_edge_is_woocommerce_installed')) {
	/**
	 * Function that checks if woocommerce is installed
	 * @return bool
	 */
	function hudson_edge_is_woocommerce_installed() {
		return function_exists('is_woocommerce');
	}
}

if(!function_exists('hudson_edge_is_woocommerce_page')) {
	/**
	 * Function that checks if current page is woocommerce shop, product or product taxonomy
	 * @return bool
	 *
	 * @see is_woocommerce()
	 */
	function hudson_edge_is_woocommerce_page() {
		return function_exists('is_woocommerce') && is_woocommerce();
	}
}

if(!function_exists('hudson_edge_edge_is_woocommerce_shop')) {
	/**
	 * Function that checks if current page is shop or product page
	 * @return bool
	 *
	 * @see is_shop()
	 */
	function hudson_edge_edge_is_woocommerce_shop() {
		return function_exists('is_shop') && is_shop();
	}
}

if(!function_exists('hudson_edge_get_woo_shop_page_id')) {
	/**
	 * Function that returns shop page id that is set in WooCommerce settings page
	 * @return int id of shop page
	 */
	function hudson_edge_get_woo_shop_page_id() {
		if(hudson_edge_is_woocommerce_installed()) {
			return get_option('woocommerce_shop_page_id');
		}
	}
}

if(!function_exists('hudson_edge_is_product_category')) {
	function hudson_edge_is_product_category() {
		return function_exists('is_product_category') && is_product_category();
	}
}

if(!function_exists('hudson_edge_load_woo_assets')) {
	/**
	 * Function that checks whether WooCommerce assets needs to be loaded.
	 *
	 * @see hudson_edge_is_ajax_enabled()
	 * @see hudson_edge_is_woocommerce_page()
	 * @see hudson_edge_has_woocommerce_shortcode()
	 * @see hudson_edge_has_woocommerce_widgets()
	 * @return bool
	 */

	function hudson_edge_load_woo_assets() {
		return hudson_edge_is_woocommerce_installed() && (hudson_edge_is_ajax_enabled() || hudson_edge_is_woocommerce_page() ||
			hudson_edge_has_woocommerce_shortcode() || hudson_edge_has_woocommerce_widgets());
	}
}

if(!function_exists('hudson_edge_has_woocommerce_shortcode')) {
	/**
	 * Function that checks if current page has at least one of WooCommerce shortcodes added
	 * @return bool
	 */
	function hudson_edge_has_woocommerce_shortcode() {
		$woocommerce_shortcodes = array(
			'woocommerce_order_tracking',
			'add_to_cart',
			'product',
			'products',
			'product_categories',
			'product_category',
			'recent_products',
			'featured_products',
			'woocommerce_messages',
			'woocommerce_cart',
			'woocommerce_checkout',
			'woocommerce_my_account',
			'woocommerce_edit_address',
			'woocommerce_change_password',
			'woocommerce_view_order',
			'woocommerce_pay',
			'woocommerce_thankyou'
		);

		foreach ($woocommerce_shortcodes as $woocommerce_shortcode) {
			$has_shortcode = hudson_edge_has_shortcode($woocommerce_shortcode);

			if($has_shortcode) {
				return true;
			}
		}

		return false;
	}
}

if(!function_exists('hudson_edge_has_woocommerce_widgets')) {
	/**
	 * Function that checks if current page has at least one of WooCommerce shortcodes added
	 * @return bool
	 */
	function hudson_edge_has_woocommerce_widgets() {
		$widgets_array = array(
			'edgt_woocommerce_dropdown_cart',
			'woocommerce_widget_cart',
			'woocommerce_layered_nav',
			'woocommerce_layered_nav_filters',
			'woocommerce_price_filter',
			'woocommerce_product_categories',
			'woocommerce_product_search',
			'woocommerce_product_tag_cloud',
			'woocommerce_products',
			'woocommerce_recent_reviews',
			'woocommerce_recently_viewed_products',
			'woocommerce_top_rated_products'
		);

		foreach ($widgets_array as $widget) {
			$active_widget = is_active_widget(false, false, $widget);

			if($active_widget) {
				return true;
			}
		}

		return false;
	}
}

if(!function_exists('hudson_edge_get_woocommerce_pages')) {
	/**
	 * Function that returns all url woocommerce pages
	 * @return array array of WooCommerce pages
	 *
	 * @version 0.1
	 */
	function hudson_edge_get_woocommerce_pages() {
		$woo_pages_array = array();

		if(hudson_edge_is_woocommerce_installed()) {
			if(get_option('woocommerce_shop_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option('woocommerce_shop_page_id')); }
			if(get_option('woocommerce_cart_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option('woocommerce_cart_page_id')); }
			if(get_option('woocommerce_checkout_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option('woocommerce_checkout_page_id')); }
			if(get_option('woocommerce_pay_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_pay_page_id ')); }
			if(get_option('woocommerce_thanks_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_thanks_page_id ')); }
			if(get_option('woocommerce_myaccount_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_myaccount_page_id ')); }
			if(get_option('woocommerce_edit_address_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_edit_address_page_id ')); }
			if(get_option('woocommerce_view_order_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_view_order_page_id ')); }
			if(get_option('woocommerce_terms_page_id') != ''){ $woo_pages_array[] = get_permalink(get_option(' woocommerce_terms_page_id ')); }

			$woo_products = get_posts(array('post_type' => 'product','post_status' => 'publish', 'posts_per_page' => '-1') );

			foreach($woo_products as $product) {
				$woo_pages_array[] = get_permalink($product->ID);
			}
		}

		return $woo_pages_array;
	}
}

if(!function_exists('hudson_edge_woocommerce_columns_class')) {
	/**
	 * Function that adds number of columns class to header tag
	 * @param array array of classes from main filter
	 * @return array array of classes with added bottom header appearance class
	 */
	function hudson_edge_woocommerce_columns_class($classes) {
		global $hudson_edge_options;

		if (in_array("woocommerce", $classes)) {
			$products_list_number = 'columns-3';
			if(isset($hudson_edge_options['woo_products_list_number'])){
				$products_list_number = $hudson_edge_options['woo_products_list_number'];
			}
			$classes[]= $products_list_number;
			
			$products_list_type="";
			if(isset($hudson_edge_options['woo_products_list_type'])){
				$products_list_type = $hudson_edge_options['woo_products_list_type'];
			}
			$classes[]= $products_list_type;
		}

		return $classes;
	}

	add_filter('body_class', 'hudson_edge_woocommerce_columns_class');
}


/*=================================================================================
 * #Visual Composer helper functions
 *=================================================================================*/

if(!function_exists('hudson_edge_visual_composer_installed')) {
	/**
	 * Function that checks if visual composer installed
	 * @return bool
	 */
	function hudson_edge_visual_composer_installed() {
		//is Visual Composer installed?
		if(class_exists('WPBakeryVisualComposerAbstract')) {
			return true;
		}

		return false;
	}
}

/*=================================================================================
 * #Yoast helper functions
 *=================================================================================*/
if(!function_exists('hudson_edge_seo_plugin_installed')) {
	/**
	 * Function that checks if popular seo plugins are installed
	 * @return bool
	 */
	function hudson_edge_seo_plugin_installed() {
		//is YOAST installed?
		if(defined('WPSEO_VERSION')) {
			return true;
		}

		return false;
	}
}


/*=================================================================================
 * #Contact Form 7 helper functions
 *=================================================================================*/
if(!function_exists('hudson_edge_contact_form_7_installed')) {
	/**
	 * Function that checks if contact form 7 installed
	 * @return bool
	 */
	function hudson_edge_contact_form_7_installed() {
		//is Contact Form 7 installed?
		if(defined('WPCF7_VERSION')) {
			return true;
		}

		return false;
	}
}



/*=================================================================================
 * #WPML helper functions
 *=================================================================================*/
if(!function_exists('hudson_edge_is_wpml_installed')) {
	/**
	 * Function that checks if WPML plugin is installed
	 * @return bool
	 *
	 * @version 0.1
	 */
	function hudson_edge_is_wpml_installed() {
		return defined('ICL_SITEPRESS_VERSION');
	}
}

if(!function_exists('hudson_edge_get_wpml_pages_for_current_page')) {
	/**
	 * Function that returns urls translated pages for current page.
	 * @return array array of url urls translated pages for current page.
	 *
	 * @version 0.1
	 */
	function hudson_edge_get_wpml_pages_for_current_page() {
		$wpml_pages_for_current_page = array();

		if(hudson_edge_is_wpml_installed()) {
			$language_pages = icl_get_languages('skip_missing=0');

			foreach($language_pages as $key => $language_page) {
				$wpml_pages_for_current_page[] = $language_page["url"];
			}
		}

		return $wpml_pages_for_current_page;
	}
}

if ( ! function_exists('hudson_edge_get_module_part') ) {
    function hudson_edge_get_module_part($module ) {
        return $module;
    }
}

if ( ! function_exists('hudson_edge_return_wp_filesystem') ) {
    function hudson_edge_return_wp_filesystem() {
        global $wp_filesystem;

        return $wp_filesystem;
    }
}

if ( ! function_exists('hudson_edge_return_global_options') ) {
    function hudson_edge_return_global_options() {
        global $hudson_edge_options;

        return $hudson_edge_options;
    }
}

if ( ! function_exists('hudson_edge_return_toolbar_variable') ) {
    function hudson_edge_return_toolbar_variable() {
        global $edgt_toolbar;

        return $edgt_toolbar;
    }
}

if ( ! function_exists('hudson_edge_return_global_wp_query') ) {
    function hudson_edge_return_global_wp_query() {
        global $wp_query;

        return $wp_query;
    }
}

if ( ! function_exists('hudson_edge_return_icon_collections') ) {
    function hudson_edge_return_icon_collections() {
        global $hudson_edge_icon_collections;

        return $hudson_edge_icon_collections;
    }
}

if ( ! function_exists('hudson_edge_return_framework_variable') ) {
    function hudson_edge_return_framework_variable() {
        global $hudson_edge_framework;

        return $hudson_edge_framework;
    }
}

if ( ! function_exists('hudson_edge_return_options_fontstyle') ) {
    function hudson_edge_return_options_fontstyle() {
        global $hudson_edge_options_fontstyle;

        return $hudson_edge_options_fontstyle;
    }
}

if ( ! function_exists('hudson_edge_return_options_fontweight') ) {
    function hudson_edge_return_options_fontweight() {
        global $hudson_edge_options_fontweight;

        return $hudson_edge_options_fontweight;
    }
}

if ( ! function_exists('hudson_edge_return_options_texttransform') ) {
    function hudson_edge_return_options_texttransform() {
        global $hudson_edge_options_texttransform;

        return $hudson_edge_options_texttransform;
    }
}

if ( ! function_exists('hudson_edge_return_options_fontdecoration') ) {
    function hudson_edge_return_options_fontdecoration() {
        global $hudson_edge_options_fontdecoration;

        return $hudson_edge_options_fontdecoration;
    }
}

if ( ! function_exists('hudson_edge_return_options_arrows_type') ) {
    function hudson_edge_return_options_arrows_type() {
        global $hudson_edge_options_arrows_type;

        return $hudson_edge_options_arrows_type;
    }
}

if ( ! function_exists('hudson_edge_return_options_double_arrows_type') ) {
    function hudson_edge_return_options_double_arrows_type() {
        global $hudson_edge_options_double_arrows_type;

        return $hudson_edge_options_double_arrows_type;
    }
}

if ( ! function_exists('hudson_edge_return_options_arrows_up_type') ) {
    function hudson_edge_return_options_arrows_up_type() {
        global $hudson_edge_options_arrows_up_type;

        return $hudson_edge_options_arrows_up_type;
    }
}

if( ! function_exists('hudson_edge_set_three_number_of_columns') ){
    function hudson_edge_set_three_number_of_columns(){
        global $woocommerce_loop;

        $woocommerce_loop['columns'] = 3;
    }
}

if( ! function_exists('hudson_edge_set_more_variable') ){
    function hudson_edge_set_more_variable(){
        global $more;

        $more = 0;
    }
}

if ( ! function_exists( 'hudson_edge_get_sidebar_name' ) ) {
    function hudson_edge_get_sidebar_name() {
        $eden_options = hudson_edge_return_global_options();
        $page_id      = hudson_edge_get_page_id();

        if ( get_post_meta( $page_id, 'edgt_choose-sidebar', true ) != "" ) {
            $sidebar = get_post_meta( $page_id, 'edgt_choose-sidebar', true );
        } else {
            if ( is_singular( "post" ) ) {
                if ( $eden_options['blog_single_sidebar_custom_display'] != "" ) {
                    $sidebar = $eden_options['blog_single_sidebar_custom_display'];
                } else {
                    $sidebar = 'sidebar';
                }
            } else {
                $sidebar = 'sidebar_page';
            }
        }

        return $sidebar;
    }
}

if ( ! function_exists( 'hudson_edge_get_sidebar_layout' ) ) {
    function hudson_edge_get_sidebar_layout( $default_value = true ) {
        $global_options    = hudson_edge_return_global_options();
        $hudson_page_id     = hudson_edge_get_page_id();
        $show_sidebar_meta = get_post_meta( $hudson_page_id, "edgt_show-sidebar", true );
        $sidebar           = $default_value ? $global_options['category_blog_sidebar'] : '';

        if ( ! empty( $show_sidebar_meta ) ) {
            $sidebar = $show_sidebar_meta;
        }

        if ( is_singular( 'post' ) && empty( $show_sidebar_meta ) ) {
            $sidebar = $global_options['blog_single_sidebar'];
        }

        if ( is_singular( 'portfolio_page' ) && empty( $show_sidebar_meta ) && isset( $global_options['portfolio_single_sidebar'] ) ) {
            $sidebar = $global_options['portfolio_single_sidebar'];
        }

        if ( ! empty( $sidebar ) && ! is_active_sidebar( hudson_edge_get_sidebar_name() ) ) {
            $sidebar = '';
        }

        return $sidebar;
    }
}

if ( ! function_exists( 'hudson_edge_get_blog_query_posts' ) ) {
    function hudson_edge_get_blog_query_posts() {
        $edge_page_id             = hudson_edge_get_page_id();
        $category                 = get_post_meta( $edge_page_id, "edgt_choose-blog-category", true );
        $number_of_posts_per_page = get_post_meta( $edge_page_id, "edgt_show-posts-per-page", true );
        $post_number              = ! empty( $number_of_posts_per_page ) ? esc_attr( $number_of_posts_per_page ) : esc_attr( get_option( 'posts_per_page' ) );

        if ( get_query_var( 'paged' ) ) {
            $paged = get_query_var( 'paged' );
        } elseif ( get_query_var( 'page' ) ) {
            $paged = get_query_var( 'page' );
        } else {
            $paged = 1;
        }

        $query_array = array(
            'post_status'    => 'publish',
            'post_type'      => 'post',
            'paged'          => $paged,
            'cat'            => $category,
            'posts_per_page' => $post_number
        );

        $blog_query = new WP_Query( $query_array );
        if ( is_archive() ) {
            global $wp_query;
            $blog_query = $wp_query;
        }

        return $blog_query;
    }
}